// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : application.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "application.h"
#include "Button.h"
#include "Intro.h"
#include "Util.h"
#include "resource.h"



Application*        g_pApp = NULL;



Application::Application( bool FullScreen ) :
  m_pNextState( NULL ),
  m_UsingQPF( false ),
  m_pD3DSprite( NULL ),
  m_AutoAnimation( 0 ),
  m_AutoAnimationDelay( 0 ),
  m_BusyLoop( true ),
  m_ShowCursor( true )
{

  g_pApp      = this;
  m_BGOffset  = 0.0f;


  // Initialize log file
  InitLog();

  Log( "Application()  Creating Application...\n" );

  // Seed random number generator
  srand( (unsigned)time( NULL ) );

  m_FullScreen          = FullScreen;

  // Create and initialize struct for window information
  WNDCLASSEX     wc;

  ZeroMemory( &wc, sizeof( WNDCLASSEX ) );

  // Populate with window information
  wc.cbSize          = sizeof( WNDCLASSEX );
  wc.style           = CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc     = (WNDPROC)WindowProc;
  wc.hInstance       = GetModuleHandle( NULL );
  wc.hCursor         = LoadCursor( NULL, IDC_ARROW );
  wc.hIcon           = LoadIcon( GetModuleHandle( NULL ), MAKEINTRESOURCE( IDI_ICON_DOBBS ) );
  wc.hIconSm         = LoadIcon( GetModuleHandle( NULL ), MAKEINTRESOURCE( IDI_ICON_DOBBS ) );
  wc.lpszClassName   = L"WindowClass";

  // Register window class
  Log( "Application()  Registering window class...\n" );
  RegisterClassEx( &wc );

  // Create window
  Log( "Application()  Creating window...\n" );

  RECT      Size;

  SetRect( &Size, 0, 0, Dobbs::SCREEN_WIDTH, Dobbs::SCREEN_HEIGHT );

  DWORD     WindowStyle = WS_EX_TOPMOST | WS_POPUP;
  if ( !m_FullScreen )
  {
    WindowStyle = WS_OVERLAPPED | WS_MINIMIZEBOX | WS_SYSMENU | WS_CAPTION;
    AdjustWindowRectEx( &Size, WindowStyle, FALSE, WS_EX_WINDOWEDGE );
  }


  m_hWnd = CreateWindowEx( NULL,
                        L"WindowClass",             // name of the window class
                        L"Dr. Dobb's Challenges",   // title of the window
                        WindowStyle,                // window style
                        0,                          // x-position of the window
                        0,                          // y-position of the window
                        Size.right - Size.left,     // width of the window
                        Size.bottom - Size.top,     // height of the window
                        NULL,                       // we have no parent window, NULL
                        NULL,                       // we aren't using menus, NULL
                        GetModuleHandle( NULL ),    // application handle
                        NULL );                     // used with multiple windows, NULL

  // Display window
  Log( "Application()  Displaying window...\n" );
  ShowWindow( m_hWnd, SW_SHOWNORMAL );

  // Create Direct3D interface
  Log( "Application()  Initializing Direct3D...\n" );
  pD3D = Direct3DCreate9( D3D_SDK_VERSION );

  // Init and create Direct3D parameters (for new device)
  ZeroMemory( &d3dParam, sizeof( d3dParam ) );
  d3dParam.Windowed          = !m_FullScreen;          // Set windowed mode
  d3dParam.hDeviceWindow     = m_hWnd;                 // Set to the current window
  d3dParam.SwapEffect        = D3DSWAPEFFECT_DISCARD;  // Discard previous buffer after swap
  d3dParam.BackBufferFormat  = D3DFMT_X8R8G8B8;        // Set backbuffer format to 32-bit
  d3dParam.BackBufferWidth   = Dobbs::SCREEN_WIDTH;    // Set the width of buffer
  d3dParam.BackBufferHeight  = Dobbs::SCREEN_HEIGHT;   // Set the height of buffer

  // Create Direct3D interface
  if ( SUCCEEDED( pD3D->CreateDevice( D3DADAPTER_DEFAULT,
                     D3DDEVTYPE_HAL,
                     m_hWnd,
                     D3DCREATE_SOFTWARE_VERTEXPROCESSING,
                     &d3dParam,
                     &m_pD3DDevice ) ) )
  {
    m_pD3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_DIFFUSE );
    m_pD3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_TEXTURE );
    m_pD3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
    m_pD3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE );
    m_pD3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_TEXTURE );
    m_pD3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
    m_pD3DDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP, D3DTOP_DISABLE );
    m_pD3DDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_DISABLE );
    m_pD3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
    m_pD3DDevice->SetRenderState( D3DRS_ALPHATESTENABLE, TRUE );
    m_pD3DDevice->SetRenderState( D3DRS_ALPHAREF, 8 );
    m_pD3DDevice->SetRenderState( D3DRS_ALPHAFUNC, D3DCMP_GREATEREQUAL );

    D3DXCreateSprite( m_pD3DDevice, &m_pD3DSprite );

    // Initialize remaining members
    isRunning   = true;

    // make sure we're only running on one processor (to avoid frequency changes)
    DWORD         dwProcessAffinityMask, 
                  dwSysAffinityMask, 
                  dwFirstProcessorMask = 1;

	  GetProcessAffinityMask( GetCurrentProcess(), &dwProcessAffinityMask, &dwSysAffinityMask );
	  while( !( dwFirstProcessorMask & dwSysAffinityMask ) )
    {
		  dwFirstProcessorMask <<= 1;
    }
	  SetThreadAffinityMask( GetCurrentThread(), dwFirstProcessorMask );
	  Sleep( 1 );

    // Use QueryPerformanceFrequency() to get frequency of timer.  If QPF is
    // not supported, we will timeGetTime() which returns milliseconds.
    LARGE_INTEGER qwTicksPerSec;
    m_UsingQPF = QueryPerformanceFrequency( &qwTicksPerSec );
    if ( m_UsingQPF )
    {
      m_llQPFTicksPerSec = qwTicksPerSec.QuadPart;
    }
    else
    {
      // Main game loop based on isRunning status from application
      m_LastTicks           = GetTickCount();
      m_LastTicksPerFrame   = m_LastTicks;
    }
  }

}



Application::~Application() 
{

  Log("Application()  Releasing Application...\n");

  // Release Direct3D device
  m_pD3DDevice->Release();

  // Release Direct3D interface
  pD3D->Release();

  g_pApp = NULL;

}



void Application::Init() 
{

  // Initialize core components
  // NOTE:  This is not included in the constructor because it requires
  //        access to static members, which causes problems when done
  //        outside of WinMain().
  Log( "Application()  Initializing core...\n" );
  m_MouseCursorVisible = false;
  Text::Init( m_pD3DDevice, "Arial" );
  m_Input.Init( m_hWnd );
  Sound::Init( m_hWnd );

  AddSection( "Mouse", "gui.png", 104, 0, 14, 16 );

  AddSection( "Level.Selector", "gui.png", 0, 206, 245, 20 );
  AddSection( "Level.Selector.Pushed", "gui.png", 0, 226, 245, 20 );

  AddSection( "Entity.Arrow.Left",      "gui.png", 128,  0, 32, 32 );
  AddSection( "Entity.Arrow.Right",     "gui.png", 160,  0, 32, 32 );
  AddSection( "Entity.Arrow.Up",        "gui.png", 192,  0, 32, 32 );
  AddSection( "Entity.Arrow.Down",      "gui.png", 224,  0, 32, 32 );
  AddSection( "Entity.Arrow.Left.CCW",  "gui.png", 128, 32, 32, 32 );
  AddSection( "Entity.Arrow.Right.CCW", "gui.png", 160, 32, 32, 32 );
  AddSection( "Entity.Arrow.Up.CCW",    "gui.png", 192, 32, 32, 32 );
  AddSection( "Entity.Arrow.Down.CCW",  "gui.png", 224, 32, 32, 32 );
  AddSection( "Entity.Arrow.Crossed",   "gui.png", 128, 64, 12, 12 );

  AddSection( "Button.Arrow.Up.0", "gui.png", 0,  0, 26, 26 );
  AddSection( "Button.Arrow.Up.1", "gui.png", 0, 26, 26, 26 );
  AddSection( "Button.Arrow.Up.2", "gui.png", 0, 52, 26, 26 );
  AddSection( "Button.Arrow.Down.0", "gui.png", 26,  0, 26, 26 );
  AddSection( "Button.Arrow.Down.1", "gui.png", 26, 26, 26, 26 );
  AddSection( "Button.Arrow.Down.2", "gui.png", 26, 52, 26, 26 );
  AddSection( "Button.Arrow.Left.0", "gui.png", 52,  0, 26, 26 );
  AddSection( "Button.Arrow.Left.1", "gui.png", 52, 26, 26, 26 );
  AddSection( "Button.Arrow.Left.2", "gui.png", 52, 52, 26, 26 );
  AddSection( "Button.Arrow.Right.0", "gui.png", 78,  0, 26, 26 );
  AddSection( "Button.Arrow.Right.1", "gui.png", 78, 26, 26, 26 );
  AddSection( "Button.Arrow.Right.2", "gui.png", 78, 52, 26, 26 );
  AddSection( "Button.Big.0", "gui.png", 0, 78, 128, 64 );
  AddSection( "Button.Big.1", "gui.png", 0, 78 + 64, 128, 64 );

  AddSection( "BG.Empty", "bg-empty.png", 0, 0, 864, 664 );
  AddSection( "Menu.Bar", "gamegui.png", 0, 256, 512, 64 );

  AddSection( "Menu.Back", "gamegui2.png", 0, 0, 173, 55 );
  AddSection( "Menu.WindowMode", "gamegui2.png", 0, 62, 491, 69 );
  AddSection( "Menu.Volume", "gamegui2.png", 193, 0, 250, 62 );
  AddSection( "Big.0", "gamegui2.png", 0, 161, 52, 52 );
  AddSection( "Big.1", "gamegui2.png", 66, 161, 36, 50 );
  AddSection( "Big.2", "gamegui2.png", 108, 160, 48, 52 );
  AddSection( "Big.3", "gamegui2.png", 161, 160, 48, 53 );
  AddSection( "Big.4", "gamegui2.png", 215, 161, 50, 50 );
  AddSection( "Big.5", "gamegui2.png", 269, 161, 55, 54 );
  AddSection( "Big.6", "gamegui2.png", 328, 162, 43, 48 );
  AddSection( "Big.7", "gamegui2.png", 381, 161, 51, 49 );
  AddSection( "Big.8", "gamegui2.png", 0, 224, 51, 50 );
  AddSection( "Big.9", "gamegui2.png", 63, 222, 41, 54 );

  AddSection( "Explosion.1", "smoke_B-0.png", 0, 0, 256, 256 );
  AddSection( "Explosion.2", "smoke_B-1.png", 0, 0, 256, 256 );
  AddSection( "Explosion.3", "smoke_B-2.png", 0, 0, 256, 256 );
  AddSection( "Explosion.4", "smoke_B-3.png", 0, 0, 256, 256 );
  AddSection( "Explosion.5", "smoke_B-4.png", 0, 0, 256, 256 );
  AddSection( "Explosion.6", "smoke_B-5.png", 0, 0, 256, 256 );
  AddSection( "Explosion.7", "smoke_B-6.png", 0, 0, 256, 256 );
  AddSection( "Explosion.8", "smoke_B-7.png", 0, 0, 256, 256 );
  AddSection( "Explosion.9", "smoke_B-8.png", 0, 0, 256, 256 );
  AddSection( "Explosion.10", "smoke_B-9.png", 0, 0, 256, 256 );
  AddSection( "Explosion.11", "smoke_B-10.png", 0, 0, 256, 256 );
  AddSection( "Explosion.12", "smoke_B-11.png", 0, 0, 256, 256 );
  AddSection( "Explosion.13", "smoke_B-12.png", 0, 0, 256, 256 );
  AddSection( "Explosion.14", "smoke_B-13.png", 0, 0, 256, 256 );
  AddSection( "Explosion.15", "smoke_B-14.png", 0, 0, 256, 256 );
  AddSection( "Explosion.16", "smoke_B-15.png", 0, 0, 256, 256 );

  AddSection( "Tile.Grass.0", "tiles.png",   1,  1, 30, 30 );
  AddSection( "Tile.Grass.N", "tiles.png",  33,  1, 30, 30 );
  AddSection( "Tile.Grass.S", "tiles.png",  65,  1, 30, 30 );
  AddSection( "Tile.Grass.NW", "tiles.png",  97,  1, 30, 30 );
  AddSection( "Tile.Grass.NE", "tiles.png", 129,  1, 30, 30 );
  AddSection( "Tile.Grass.Center", "tiles.png", 161,  1, 30, 30 );
  AddSection( "Tile.Grass.W", "tiles.png", 193,  1, 30, 30 );
  AddSection( "Tile.Grass.E", "tiles.png", 225,  1, 30, 30 );
  AddSection( "Tile.Grass.SW", "tiles.png", 193, 33, 30, 30 );
  AddSection( "Tile.Grass.SE", "tiles.png", 225, 33, 30, 30 );

  AddSection( "Tile.Sign", "tiles.png", 33, 257, 30, 30 );

  AddSection( "Tile.Glue.0", "tiles.png", 129, 65, 30, 30 );
  AddSection( "Tile.Glue.1", "tiles.png", 161, 65, 30, 30 );
  AddSection( "Tile.Glue.2", "tiles.png", 193, 65, 30, 30 );
  AddSection( "Tile.Glue.3", "tiles.png", 225, 65, 30, 30 );
  AddSection( "Tile.Glue.4", "tiles.png",   1, 97, 30, 30 );
  AddSection( "Tile.Glue.5", "tiles.png",  33, 97, 30, 30 );
  AddSection( "Tile.Glue.Single.0", "tiles.png",  65, 97, 30, 30 );
  AddSection( "Tile.Glue.Single.1", "tiles.png",  97, 97, 30, 30 );
  AddSection( "Tile.Glue.Single.2", "tiles.png", 129, 97, 30, 30 );
  AddSection( "Tile.Glue.Single.3", "tiles.png", 161, 97, 30, 30 );
  AddSection( "Tile.Glue.Left.0", "tiles.png", 193, 97, 30, 30 );
  AddSection( "Tile.Glue.Left.1", "tiles.png", 225, 97, 30, 30 );
  AddSection( "Tile.Glue.Right.0", "tiles.png",   1, 129, 30, 30 );
  AddSection( "Tile.Glue.Right.1", "tiles.png",  33, 129, 30, 30 );

  AddSection( "Tile.Ice.0", "tiles.png", 65, 129, 30, 30 );
  AddSection( "Tile.Ice.1", "tiles.png", 97, 129, 30, 30 );
  AddSection( "Tile.Ice.Single.0", "tiles.png",  129, 129, 30, 30 );
  AddSection( "Tile.Ice.Left.0", "tiles.png", 161, 129, 30, 30 );
  AddSection( "Tile.Ice.Right.0", "tiles.png", 193, 129, 30, 30 );

  AddSection( "Tile.Steel.V", "tiles.png", 225, 129, 30, 30 );
  AddSection( "Tile.Steel", "tiles.png", 1, 161, 30, 30 );

  AddSection( "Tile.A", "tiles.png", 193, 289, 30, 30 );
  AddSection( "Tile.B", "tiles.png", 225, 289, 30, 30 );
  AddSection( "Tile.C", "tiles.png", 257, 289, 30, 30 );
  AddSection( "Tile.D", "tiles.png", 289, 289, 30, 30 );
  AddSection( "Tile.1", "tiles.png",   1, 321, 30, 30 );
  AddSection( "Tile.2", "tiles.png",  33, 321, 30, 30 );
  AddSection( "Tile.3", "tiles.png",  65, 321, 30, 30 );
  AddSection( "Tile.4", "tiles.png",  97, 321, 30, 30 );

  AddSection( "Tile.Grid.Chip.E", "tiles.png", 193, 321, 30, 30 );
  AddSection( "Tile.Grid.Chip.W", "tiles.png", 225, 321, 30, 30 );
  AddSection( "Tile.Grid.Chip.S", "tiles.png", 257, 321, 30, 30 );
  AddSection( "Tile.Grid.Chip.N", "tiles.png", 289, 321, 30, 30 );
  AddSection( "Tile.Grid.H", "tiles.png",   1, 353, 30, 30 );
  AddSection( "Tile.Grid.V", "tiles.png",  33, 353, 30, 30 );

  AddSection( "Tile.Grid.NE", "tiles.png",  65, 353, 30, 30 );
  AddSection( "Tile.Grid.NW", "tiles.png",  97, 353, 30, 30 );
  AddSection( "Tile.Grid.SE", "tiles.png", 129, 353, 30, 30 );
  AddSection( "Tile.Grid.SW", "tiles.png", 161, 353, 30, 30 );

  AddSection( "Door.Yellow", "tiles.png",  129, 161, 30, 30 );
  AddSection( "Door.Opened", "tiles.png",  33, 161, 30, 30 );
  AddSection( "Door.Yellow.2", "tiles.png",  97, 161, 30, 30 );
  AddSection( "Door.Yellow.3", "tiles.png", 129, 161, 30, 30 );
  AddSection( "Door.Red", "tiles.png",   1, 193, 30, 30 );
  AddSection( "Door.Red.1", "tiles.png", 193, 161, 30, 30 );
  AddSection( "Door.Red.2", "tiles.png", 225, 161, 30, 30 );
  AddSection( "Door.Red.3", "tiles.png",   1, 193, 30, 30 );
  AddSection( "Door.Green", "tiles.png",  129, 193, 30, 30 );
  AddSection( "Door.Green.1", "tiles.png",  65, 193, 30, 30 );
  AddSection( "Door.Green.2", "tiles.png",  97, 193, 30, 30 );
  AddSection( "Door.Green.3", "tiles.png", 129, 193, 30, 30 );
  AddSection( "Door.Blue", "tiles.png",     1, 225, 30, 30 );
  AddSection( "Door.Blue.1", "tiles.png", 193, 193, 30, 30 );
  AddSection( "Door.Blue.2", "tiles.png", 225, 193, 30, 30 );
  AddSection( "Door.Blue.3", "tiles.png",   1, 225, 30, 30 );

  AddSection( "Tile.Bridge", "tiles.png",  33, 225, 30, 30 );
  AddSection( "Tile.Spikes", "tiles.png",  65, 225, 30, 30 );

  //AddSection( "Tile.Platine.NE", "tiles.png", 64, 256, 32, 32 );
  //AddSection( "Tile.Platine.NW", "tiles.png", 96, 256, 32, 32 );
  //AddSection( "Tile.Platine.Sign.0", "tiles.png", 128, 256, 32, 32 );
  //AddSection( "Tile.Platine.Sign.1", "tiles.png", 160, 256, 32, 32 );
  AddSection( "Tile.Platine.NE", "tiles.png", 65, 257, 30, 30 );
  AddSection( "Tile.Platine.NW", "tiles.png", 97, 257, 30, 30 );
  AddSection( "Tile.Platine.Sign.0", "tiles.png", 129, 257, 30, 30 );
  AddSection( "Tile.Platine.Sign.1", "tiles.png", 161, 257, 30, 30 );

  AddSection( "Tile.Door.Metal", "tiles.png", 193, 257, 30, 30 );
  AddSection( "Tile.Door.Metal.Open", "tiles.png", 225, 257, 30, 30 );

  AddSection( "Tile.Water.Top.0", "tiles.png", 257, 65, 30, 30 );
  AddSection( "Tile.Water.Top.1", "tiles.png", 289, 65, 30, 30 );
  AddSection( "Tile.Water.Top.2", "tiles.png", 321, 65, 30, 30 );
  AddSection( "Tile.Water.Top.3", "tiles.png", 353, 65, 30, 30 );
  AddSection( "Tile.Water", "tiles.png", 385, 65, 30, 30 );

  AddSection( "Token.0", "tokens.png",   0, 0, 36, 24 );
  AddSection( "Token.1", "tokens.png",  36, 0, 36, 24 );
  AddSection( "Token.2", "tokens.png",  72, 0, 36, 24 );
  AddSection( "Token.3", "tokens.png", 108, 0, 36, 24 );
  AddSection( "Token.4", "tokens.png", 144, 0, 36, 24 );
  AddSection( "Token.5", "tokens.png", 180, 0, 36, 24 );
  AddSection( "Token.6", "tokens.png", 216, 0, 36, 24 );
  AddSection(  "Token.7", "tokens.png",   0, 24, 36, 24 );
  AddSection(  "Token.8", "tokens.png",  36, 24, 36, 24 );
  AddSection(  "Token.9", "tokens.png",  72, 24, 36, 24 );
  AddSection( "Token.10", "tokens.png", 108, 24, 36, 24 );
  AddSection( "Token.11", "tokens.png", 144, 24, 36, 24 );
  AddSection( "Token.12", "tokens.png", 180, 24, 36, 24 );
  AddSection( "Token.13", "tokens.png", 216, 24, 36, 24 );
  AddSection( "Token.14", "tokens.png",   0, 48, 36, 24 );
  AddSection( "Token.15", "tokens.png",  36, 48, 36, 24 );
  AddSection( "Token.16", "tokens.png",  72, 48, 36, 24 );
  AddSection( "Token.17", "tokens.png", 108, 48, 36, 24 );
  AddSection( "Token.18", "tokens.png", 144, 48, 36, 24 );
  AddSection( "Token.19", "tokens.png", 180, 48, 36, 24 );
  AddSection( "Token.20", "tokens.png", 216, 48, 36, 24 );
  AddSection( "Token.21", "tokens.png",   0, 72, 36, 24 );
  AddSection( "Token.22", "tokens.png",  36, 72, 36, 24 );
  AddSection( "Token.23", "tokens.png",  72, 72, 36, 24 );
  AddSection( "Token.24", "tokens.png", 108, 72, 36, 24 );
  AddSection( "Token.25", "tokens.png", 144, 72, 36, 24 );
  AddSection( "Token.26", "tokens.png", 180, 72, 36, 24 );
  AddSection( "Token.27", "tokens.png", 216, 72, 36, 24 );
  AddSection( "Token.28", "tokens.png",   0, 96, 36, 24 );
  AddSection( "Token.29", "tokens.png",  36, 96, 36, 24 );
  AddSection( "Token.30", "tokens.png",  72, 96, 36, 24 );
  AddSection( "Token.31", "tokens.png", 108, 96, 36, 24 );
  AddSection( "Token.32", "tokens.png", 144, 96, 36, 24 );
  AddSection( "Token.33", "tokens.png", 180, 96, 36, 24 );
  AddSection( "Token.34", "tokens.png", 216, 96, 36, 24 );
  AddSection( "Token.35", "tokens.png",   0, 120, 36, 24 );
  AddSection( "Token.36", "tokens.png",  36, 120, 36, 24 );
  AddSection( "Token.37", "tokens.png",  72, 120, 36, 24 );
  AddSection( "Token.38", "tokens.png", 108, 120, 36, 24 );
  AddSection( "Token.39", "tokens.png", 144, 120, 36, 24 );
  AddSection( "Token.40", "tokens.png", 180, 120, 36, 24 );

  AddSection( "Anomaly.0", "tokens.png", 0, 320, 128, 128 );
  AddSection( "Anomaly.1", "tokens.png", 128, 320, 128, 128 );

  AddSection( "Enemy.Shot.0", "tokens.png", 128, 208, 16, 16 );
  AddSection( "Enemy.Shot.1", "tokens.png", 144, 208, 16, 16 );

  AddSection( "TokenCollector", "tokens.png", 0, 224, 64, 64 );

  AddSection( "Key.Red", "tokens.png", 0, 160, 32, 32 );
  AddSection( "Key.Yellow", "tokens.png", 32, 160, 32, 32 );
  AddSection( "Key.Blue", "tokens.png", 64, 160, 32, 32 );
  AddSection( "Key.Green", "tokens.png", 96, 160, 32, 32 );
  AddSection( "JumpBoots", "tokens.png", 128, 160, 43, 35 );

  AddSection( "Game.GetReady", "gamegui.png", 0, 0, 398, 69 );
  AddSection( "Game.Victory", "gamegui.png", 0, 77, 335, 68 );
  AddSection( "Game.Dead", "gamegui.png", 0, 146, 373, 68 );

  AddSection( "Tile.Flash.1", "tiles.png",  97, 225, 30, 30 );
  AddSection( "Tile.Flash.2", "tiles.png", 129, 225, 30, 30 );
  AddSection( "Tile.Flash.3", "tiles.png", 161, 225, 30, 30 );
  AddSection( "Tile.FlashH.1", "tiles.png", 193, 225, 30, 30 );
  AddSection( "Tile.FlashH.2", "tiles.png", 225, 225, 30, 30 );
  AddSection( "Tile.FlashH.3", "tiles.png",   1, 257, 30, 30 );

  AddSection( "Tile.Black", "tiles.png", 321, 1, 30, 30 );

  AddSection( "Tile.Wall.Metal.V", "tiles.png", 353, 1, 30, 30 );
  AddSection( "Tile.Wall.Metal.H", "tiles.png", 385, 1, 30, 30 );
  AddSection( "Tile.Wall.Metal.V.Tiled", "tiles.png", 417, 1, 30, 30 );
  AddSection( "Tile.Wall.Metal.H.Tiled", "tiles.png", 449, 1, 30, 30 );

  AddSection( "Tile.Cyber.Back", "tiles.png", 1, 289, 30, 30 );

  AddSection( "Tile.Wall.Holder.N", "tiles.png", 33, 289, 30, 30 );
  AddSection( "Tile.Wall.Holder.E", "tiles.png", 65, 289, 30, 30 );
  AddSection( "Tile.Wall.Holder.W", "tiles.png", 97, 289, 30, 30 );
  AddSection( "Tile.Wall.Holder.S", "tiles.png", 129, 289, 30, 30 );

  AddSection( "Tile.Track", "tiles.png", 257, 129, 30, 30 );

  AddSection( "Tile.Platform.Metal", "tiles.png", 161, 289, 30, 30 );

  AddSection( "Tile.Arrow.Right", "tiles.png", 129, 321, 30, 30 );
  AddSection( "Tile.Arrow.Left", "tiles.png", 161, 321, 30, 30 );

  AddSection( "Switch.On", "tiles.png", 256, 0, 62, 32 );
  AddSection( "Switch.Off", "tiles.png", 256, 32, 62, 32 );

  AddSection( "Tile.Lockdown", "tiles.png", 481, 1, 30, 30 );
  AddSection( "Tile.Lockdown.Open", "tiles.png", 481, 33, 30, 30 );

  AddSection( "Tile.Spikes.N", "tiles.png", 321, 33, 30, 30 );
  AddSection( "Tile.Spikes.E", "tiles.png", 353, 33, 30, 30 );
  AddSection( "Tile.Spikes.W", "tiles.png", 385, 33, 30, 30 );
  AddSection( "Tile.Spikes.S", "tiles.png", 417, 33, 30, 30 );

  AddSection( "Tile.Kelp.1.0", "tiles.png", 257, 161, 30, 30 );
  AddSection( "Tile.Kelp.1.1", "tiles.png", 289, 161, 30, 30 );
  AddSection( "Tile.Kelp.2.0", "tiles.png", 257, 193, 30, 30 );
  AddSection( "Tile.Kelp.2.1", "tiles.png", 289, 193, 30, 30 );
  AddSection( "Tile.KelpV.1.0", "tiles.png", 321, 193, 30, 30 );
  AddSection( "Tile.KelpV.1.1", "tiles.png", 353, 193, 30, 30 );
  AddSection( "Tile.KelpV.2.0", "tiles.png", 321, 161, 30, 30 );
  AddSection( "Tile.KelpV.2.1", "tiles.png", 353, 161, 30, 30 );

  AddSection( "Tile.Wall.Edge.LO", "tiles.png", 417, 65, 30, 30 );
  AddSection( "Tile.Wall.Edge.RO", "tiles.png", 449, 65, 30, 30 );
  AddSection( "Tile.Wall.Edge.LU", "tiles.png", 481, 65, 30, 30 );
  AddSection( "Tile.Wall.Edge.RU", "tiles.png", 417, 97, 30, 30 );

  AddSection( "FX.Star.1", "gamegui.png",  1, 225, 14, 14 );
  AddSection( "FX.Star.2", "gamegui.png", 17, 225, 14, 14 );
  AddSection( "FX.Star.3", "gamegui.png", 33, 225, 14, 14 );

  AddSection( "Dobbs.Run.Left.0", "dobbsLRun-0.png", 0, 0, 42, 64 );
  AddSection( "Dobbs.Run.Left.1", "dobbsLRun-1.png", 0, 0, 42, 64 );
  AddSection( "Dobbs.Run.Left.2", "dobbsLRun-2.png", 0, 0, 42, 64 );
  AddSection( "Dobbs.Run.Left.3", "dobbsLRun-3.png", 0, 0, 42, 64 );
  AddSection( "Dobbs.Run.Left.4", "dobbsLRun-4.png", 0, 0, 42, 64 );
  AddSection( "Dobbs.Run.Left.5", "dobbsLRun-5.png", 0, 0, 42, 64 );
  AddSection( "Dobbs.Run.Left.6", "dobbsLRun-6.png", 0, 0, 42, 64 );
  AddSection( "Dobbs.Run.Left.7", "dobbsLRun-7.png", 0, 0, 42, 64 );
  AddSection( "Dobbs.Run.Left.8", "dobbsLRun-8.png", 0, 0, 42, 64 );
  AddSection( "Dobbs.Run.Left.9", "dobbsLRun-9.png", 0, 0, 42, 64 );
  AddSection( "Dobbs.Run.Left.10", "dobbsLRun-10.png", 0, 0, 42, 64 );
  AddSection( "Dobbs.Run.Right.0", "dobbsRRun-0.png", 22, 0, 42, 64 );
  AddSection( "Dobbs.Run.Right.1", "dobbsRRun-1.png", 22, 0, 42, 64 );
  AddSection( "Dobbs.Run.Right.2", "dobbsRRun-2.png", 22, 0, 42, 64 );
  AddSection( "Dobbs.Run.Right.3", "dobbsRRun-3.png", 22, 0, 42, 64 );
  AddSection( "Dobbs.Run.Right.4", "dobbsRRun-4.png", 22, 0, 42, 64 );
  AddSection( "Dobbs.Run.Right.5", "dobbsRRun-5.png", 22, 0, 42, 64 );
  AddSection( "Dobbs.Run.Right.6", "dobbsRRun-6.png", 22, 0, 42, 64 );
  AddSection( "Dobbs.Run.Right.7", "dobbsRRun-7.png", 22, 0, 42, 64 );
  AddSection( "Dobbs.Run.Right.8", "dobbsRRun-8.png", 22, 0, 42, 64 );
  AddSection( "Dobbs.Run.Right.9", "dobbsRRun-9.png", 22, 0, 42, 64 );
  AddSection( "Dobbs.Run.Right.10", "dobbsRRun-10.png", 22, 0, 42, 64 );
  AddSection( "Dobbs.Jump.Left", "dobbsLJump-0.png", 0, 0, 42, 64 );
  AddSection( "Dobbs.Jump.Right", "dobbsRJump-0.png", 0, 0, 42, 64 );
  AddSection( "Dobbs.Stand.Left", "dobbsLStand-0.png", 0, 0, 42, 64 );
  AddSection( "Dobbs.Stand.Right", "dobbsRStand-0.png", 0, 0, 42, 64 );
  AddSection( "Dobbs.Drop.Left", "DobbsLDrop.png", 0, 0, 42, 64 );
  AddSection( "Dobbs.Drop.Right", "DobbsRDrop.png", 0, 0, 42, 64 );

  AddSection( "Bug.Walk.L.0", "tokens.png", 256,  0, 64, 32 );
  AddSection( "Bug.Walk.L.1", "tokens.png", 320,  0, 64, 32 );
  AddSection( "Bug.Walk.L.2", "tokens.png", 384,  0, 64, 32 );
  AddSection( "Bug.Walk.L.3", "tokens.png", 448,  0, 64, 32 );
  AddSection( "Bug.Walk.L.4", "tokens.png", 256, 32, 64, 32 );
  AddSection( "Bug.Walk.L.5", "tokens.png", 320, 32, 64, 32 );
  AddSection( "Bug.Walk.L.6", "tokens.png", 384, 32, 64, 32 );
  AddSection( "Bug.Walk.L.7", "tokens.png", 448, 32, 64, 32 );
  AddSection( "Bug.Walk.R.3", "tokens.png", 256, 64, 64, 32 );
  AddSection( "Bug.Walk.R.2", "tokens.png", 320, 64, 64, 32 );
  AddSection( "Bug.Walk.R.1", "tokens.png", 384, 64, 64, 32 );
  AddSection( "Bug.Walk.R.0", "tokens.png", 448, 64, 64, 32 );
  AddSection( "Bug.Walk.R.7", "tokens.png", 256, 96, 64, 32 );
  AddSection( "Bug.Walk.R.6", "tokens.png", 320, 96, 64, 32 );
  AddSection( "Bug.Walk.R.5", "tokens.png", 384, 96, 64, 32 );
  AddSection( "Bug.Walk.R.4", "tokens.png", 448, 96, 64, 32 );

  AddSection( "Fly.L.0", "units2.png", 0, 0, 64, 73 );
  AddSection( "Fly.L.1", "units2.png", 64, 0, 64, 73 );
  AddSection( "Fly.R.0", "units2.png", 128, 0, 64, 73 );
  AddSection( "Fly.R.1", "units2.png", 192, 0, 64, 73 );


  AddSection( "Car.1", "tokens.png", 256, 128, 64, 35 );
  AddSection( "Car.2", "tokens.png", 320, 128, 64, 35 );

  AddSection( "Background", "bg.png", 0, 0, Dobbs::SCREEN_WIDTH, Dobbs::SCREEN_HEIGHT );
  AddSection( "Instructions", "menu_instructions.png", 0, 0, Dobbs::SCREEN_WIDTH, Dobbs::SCREEN_HEIGHT );
  AddSection( "Menu", "menu.png", 0, 0, Dobbs::SCREEN_WIDTH, Dobbs::SCREEN_HEIGHT );
  AddSection( "Dimmer", "dimmer.png", 0, 0, Dobbs::SCREEN_WIDTH, Dobbs::SCREEN_HEIGHT );

  AddSection( "Exit.Sign.0", "tokens.png", 0, 192, 64, 32 );
  AddSection( "Exit.Sign.1", "tokens.png", 64, 192, 64, 32 );
  AddSection( "Door", "tokens.png", 192, 160, 64, 64 );
  AddSection( "Door.Locked", "tokens.png", 64, 256, 64, 64 );

  AddSection( "Laser.D", "tokens.png", 64, 224, 32, 32 );
  AddSection( "Laser.U", "tokens.png", 96, 224, 32, 32 );
  AddSection( "Laser.R", "tokens.png", 128, 224, 32, 32 );
  AddSection( "Laser.L", "tokens.png", 160, 224, 32, 32 );

  AddSection( "Laser.H.1", "tokens.png",  288, 224, 32, 32 );
  AddSection( "Laser.H.2", "tokens.png", 320, 224, 32, 32 );
  AddSection( "Laser.H.3", "tokens.png", 352, 224, 32, 32 );
  AddSection( "Laser.V.1", "tokens.png", 192, 224, 32, 32 );
  AddSection( "Laser.V.2", "tokens.png", 224, 224, 32, 32 );
  AddSection( "Laser.V.3", "tokens.png", 256, 224, 32, 32 );

  AddSection( "Entity.Eye.Closed", "tokens.png", 128, 256, 36, 36 );
  AddSection( "Entity.Eye.Half", "tokens.png", 164, 256, 36, 36 );
  AddSection( "Entity.Eye.Open", "tokens.png", 200, 256, 36, 36 );

  AddSection( "Platform", "tokens.png", 384, 224, 128, 32 );

  AddSection( "Particle.Explosion.1", "tokens.png", 256, 256, 32, 32 );
  AddSection( "Particle.Explosion.2", "tokens.png", 288, 256, 16, 16 );
  AddSection( "Particle.Explosion.3", "tokens.png", 304, 256, 8, 8 );

  AddSection( "Cannon", "tokens.png", 320, 256, 64, 64 );
  AddSection( "Cannon.Full", "tokens.png", 320, 256 + 64, 64, 64 );

  AddSection( "Fish.Swim.L.0", "tokens.png", 384, 256, 48, 48 );
  AddSection( "Fish.Swim.L.1", "tokens.png", 448, 256, 48, 48 );
  AddSection( "Fish.Jump", "tokens.png", 384, 320, 48, 48 );
  AddSection( "Fish.Fall", "tokens.png", 448, 320, 48, 48 );
  AddSection( "Fish.Swim.R.0", "tokens.png", 384, 384, 48, 48 );
  AddSection( "Fish.Swim.R.1", "tokens.png", 448, 384, 48, 48 );

  AddSection( "Menu.Play", "gamegui.png", 0, 320, 174, 64 );
  AddSection( "Menu.Options", "gamegui.png", 180, 320, 270, 62 );
  AddSection( "Menu.Quit", "gamegui.png", 0, 385, 167, 70 );

  AddSection( "Sub.R", "tokens.png", 256, 320, 64, 64 );
  AddSection( "Sub.L", "tokens.png", 256, 384, 64, 64 );
  AddSection( "Sub.Empty", "tokens.png", 256, 384 + 64, 64, 64 );
  AddSection( "Sub.Shot", "tokens.png", 448, 128, 48, 32 );

  AddSection( "Bubble.Big", "tokens.png", 384, 128, 16, 16 );
  AddSection( "Bubble.Small", "tokens.png", 416, 128, 8, 8 );

  AddSection( "Player.Warp", "tokens.png", 256, 176, 32, 48 );

  AddSection( "SecurityPass", "tokens.png", 0, 288, 32, 32 );

  AddSection( "GUI.InGame", "ingamegui.png", 0, 0, 512, 176 );
  AddSection( "GUI.Dobbs", "menugui.png", 0, 0, 269, 85 );
  AddSection( "GUI.Challenge", "menugui.png", 0, 96, 424, 86 );
  AddSection( "GUI.Doctor", "menugui.png", 0, 192, 86, 184 );

  AddSection( "Shodan", "ingamegui.png", 16, 16, 100, 100 );

  AddSection( "Cursor", "tiles.png", 256, 96, 23, 32 );

  AddFramesToAnimation( Dobbs::ANIM_PLAYER_RUN_LEFT, "Dobbs.Run.Left.", 0, 10, 0.04f );
  AddFramesToAnimation( Dobbs::ANIM_PLAYER_RUN_RIGHT, "Dobbs.Run.Right.", 0, 10, 0.04f );
  AddFrameToAnimation( Dobbs::ANIM_PLAYER_STAND_LEFT, "Dobbs.Stand.Left", 0.02f );
  AddFrameToAnimation( Dobbs::ANIM_PLAYER_STAND_RIGHT, "Dobbs.Stand.Right", 0.02f );
  AddFrameToAnimation( Dobbs::ANIM_PLAYER_JUMP_LEFT, "Dobbs.Jump.Left", 0.02f );
  AddFrameToAnimation( Dobbs::ANIM_PLAYER_JUMP_RIGHT, "Dobbs.Jump.Right", 0.02f );
  AddFrameToAnimation( Dobbs::ANIM_PLAYER_DROP_LEFT, "Dobbs.Drop.Left", 0.02f );
  AddFrameToAnimation( Dobbs::ANIM_PLAYER_DROP_RIGHT, "Dobbs.Drop.Right", 0.02f );
  AddFramesToAnimation( Dobbs::ANIM_TOKEN_ROTATE, "Token.", 0, 40, 0.05f );

  AddFramesToAnimation( Dobbs::ANIM_BUG_WALK_L, "Bug.Walk.L.", 0, 7, 0.05f );
  AddFramesToAnimation( Dobbs::ANIM_BUG_WALK_R, "Bug.Walk.R.", 0, 7, 0.05f );

  AddFrameToAnimation( Dobbs::ANIM_EXIT_SIGN, "Exit.Sign.0", 0.2f );
  AddFrameToAnimation( Dobbs::ANIM_EXIT_SIGN, "Exit.Sign.1", 0.2f );

  AddFrameToAnimation( Dobbs::ANIM_DOOR, "Door" );
  AddFrameToAnimation( Dobbs::ANIM_DOOR_LOCKED, "Door.Locked" );

  AddFrameToAnimation( Dobbs::ANIM_KEY_BLUE, "Key.Blue", 1000.0f );
  AddFrameToAnimation( Dobbs::ANIM_KEY_GREEN, "Key.Green", 1000.0f );
  AddFrameToAnimation( Dobbs::ANIM_KEY_RED, "Key.Red", 1000.0f );
  AddFrameToAnimation( Dobbs::ANIM_KEY_YELLOW, "Key.Yellow", 1000.0f );

  AddFrameToAnimation( Dobbs::ANIM_CAR, "Car.1", 0.05f );
  AddFrameToAnimation( Dobbs::ANIM_CAR, "Car.2", 0.05f );

  AddFrameToAnimation( Dobbs::ANIM_SWITCH_ON, "Switch.On" );
  AddFrameToAnimation( Dobbs::ANIM_SWITCH_OFF, "Switch.Off" );

  AddFrameToAnimation( Dobbs::ANIM_TOKEN_COLLECTOR, "TokenCollector" );

  AddFrameToAnimation( Dobbs::ANIM_LASER_D, "Laser.D" );
  AddFrameToAnimation( Dobbs::ANIM_LASER_U, "Laser.U" );
  AddFrameToAnimation( Dobbs::ANIM_LASER_L, "Laser.L" );
  AddFrameToAnimation( Dobbs::ANIM_LASER_R, "Laser.R" );

  AddFramesToAnimation( Dobbs::ANIM_LASER_H, "Laser.H.", 1, 3, 0.1f );
  AddFramesToAnimation( Dobbs::ANIM_LASER_V, "Laser.V.", 1, 3, 0.1f );

  AddFramesToAnimation( Dobbs::ANIM_EXPLOSION, "Explosion.", 1, 15, 0.05f );
  AddFrameToAnimation( Dobbs::ANIM_EXPLOSION, "Explosion.16" );

  AddFramesToAnimation( Dobbs::ANIM_ENEMY_EXPLODE, "Explosion.", 1, 4, 0.05f );
  AddFrameToAnimation( Dobbs::ANIM_ENEMY_EXPLODE, "Explosion.3", 0.025f );
  AddFrameToAnimation( Dobbs::ANIM_ENEMY_EXPLODE, "Explosion.2", 0.025f );
  AddFrameToAnimation( Dobbs::ANIM_ENEMY_EXPLODE, "Explosion.1" );

  AddFrameToAnimation( Dobbs::ANIM_EYE_OPEN, "Entity.Eye.Closed", 0.2f );
  AddFrameToAnimation( Dobbs::ANIM_EYE_OPEN, "Entity.Eye.Half", 0.2f );
  AddFrameToAnimation( Dobbs::ANIM_EYE_OPEN, "Entity.Eye.Open", 1000.0f );

  AddFrameToAnimation( Dobbs::ANIM_EYE_LOOK, "Entity.Eye.Open", 1000.0f );

  AddFrameToAnimation( Dobbs::ANIM_EYE_CLOSE, "Entity.Eye.Open", 0.2f );
  AddFrameToAnimation( Dobbs::ANIM_EYE_CLOSE, "Entity.Eye.Half", 0.2f );
  AddFrameToAnimation( Dobbs::ANIM_EYE_CLOSE, "Entity.Eye.Closed", 1000.0f );

  AddFrameToAnimation( Dobbs::ANIM_EYE_SLEEP, "Entity.Eye.Closed", 1000.0f );

  AddFramesToAnimation( Dobbs::ANIM_ANOMALY, "Anomaly.", 0, 1, 0.05f );

  AddFramesToAnimation( Dobbs::ANIM_SHOT, "Enemy.Shot.", 0, 1, 0.05f );

  AddFrameToAnimation( Dobbs::ANIM_PLATFORM, "Platform" );

  AddFrameToAnimation( Dobbs::ANIM_EXPLOSION_PARTICLE_BIG, "Particle.Explosion.1" );
  AddFrameToAnimation( Dobbs::ANIM_EXPLOSION_PARTICLE_MEDIUM, "Particle.Explosion.2" );
  AddFrameToAnimation( Dobbs::ANIM_EXPLOSION_PARTICLE_SMALL, "Particle.Explosion.3" );

  AddFrameToAnimation( Dobbs::ANIM_CANNON, "Cannon" );
  AddFrameToAnimation( Dobbs::ANIM_CANNON_FULL, "Cannon.Full" );

  AddFramesToAnimation( Dobbs::ANIM_FISH_SWIM_L, "Fish.Swim.L.", 0, 1, 0.2f );
  AddFramesToAnimation( Dobbs::ANIM_FISH_SWIM_R, "Fish.Swim.R.", 0, 1, 0.2f );
  AddFrameToAnimation( Dobbs::ANIM_FISH_JUMP, "Fish.Jump" );
  AddFrameToAnimation( Dobbs::ANIM_FISH_FALL, "Fish.Fall" );

  AddFrameToAnimation( Dobbs::ANIM_SUB_L, "Sub.L" );
  AddFrameToAnimation( Dobbs::ANIM_SUB_R, "Sub.R" );
  AddFrameToAnimation( Dobbs::ANIM_SUB_EMPTY, "Sub.Empty" );
  AddFrameToAnimation( Dobbs::ANIM_SUB_SHOT, "Sub.Shot" );

  AddFrameToAnimation( Dobbs::ANIM_BUBBLE_BIG, "Bubble.Big" );
  AddFrameToAnimation( Dobbs::ANIM_BUBBLE_SMALL, "Bubble.Small" );

  AddFrameToAnimation( Dobbs::ANIM_PLAYER_WARP, "Player.Warp" );

  AddFrameToAnimation( Dobbs::ANIM_SECURITY_PASS, "SecurityPass" );

  AddFramesToAnimation( Dobbs::ANIM_FLY_R, "Fly.R.", 0, 1, 0.02f );
  AddFramesToAnimation( Dobbs::ANIM_FLY_L, "Fly.L.", 0, 1, 0.02f );

  AddFrameToAnimation( Dobbs::ANIM_SHODAN, "Shodan" );

  AddTile( Dobbs::TILE_EMPTY, "" );
  AddTile( Dobbs::TILE_GRASS, "Tile.Grass.0" );
  AddTile( Dobbs::TILE_BRIDGE, "Tile.Bridge" );
  AddTile( Dobbs::TILE_DOOR_BLUE, "Door.Blue" );
  AddTile( Dobbs::TILE_DOOR_GREEN, "Door.Green" );
  AddTile( Dobbs::TILE_DOOR_RED, "Door.Red" );
  AddTile( Dobbs::TILE_DOOR_YELLOW, "Door.Yellow" );
  AddTile( Dobbs::TILE_FLASH, "Tile.Flash.1" );
  AddTile( Dobbs::TILE_FLASH, "Tile.Flash.2" );
  AddTile( Dobbs::TILE_FLASH, "Tile.Flash.3" );
  AddTile( Dobbs::TILE_GLUE, "Tile.Glue.0" );
  AddTile( Dobbs::TILE_ICE, "Tile.Ice.0" );
  AddTile( Dobbs::TILE_SPIKE, "Tile.Spikes" );
  AddTile( Dobbs::TILE_STEEL, "Tile.Steel" );
  AddTile( Dobbs::TILE_V_STEEL, "Tile.Steel.V" );

  AddTile( Dobbs::TILE_GRASS_N, "Tile.Grass.N" );
  AddTile( Dobbs::TILE_GRASS_S, "Tile.Grass.S" );
  AddTile( Dobbs::TILE_GRASS_NW, "Tile.Grass.NW" );
  AddTile( Dobbs::TILE_GRASS_NE, "Tile.Grass.NE" );
  AddTile( Dobbs::TILE_GRASS_CENTER, "Tile.Grass.Center" );
  AddTile( Dobbs::TILE_GRASS_W, "Tile.Grass.W" );
  AddTile( Dobbs::TILE_GRASS_E, "Tile.Grass.E" );
  AddTile( Dobbs::TILE_GRASS_SW, "Tile.Grass.SW" );
  AddTile( Dobbs::TILE_GRASS_SE, "Tile.Grass.SE" );
  AddTile( Dobbs::TILE_SIGN, "Tile.Sign" );
  AddTile( Dobbs::TILE_BLACK, "Tile.Black" );
  AddTile( Dobbs::TILE_PLATINE_NE, "Tile.Platine.NE" );
  AddTile( Dobbs::TILE_PLATINE_NW, "Tile.Platine.NW" );
  AddTile( Dobbs::TILE_SCREEN_SIGN, "Tile.Platine.Sign.0" );
  AddTile( Dobbs::TILE_SCREEN_SIGN, "Tile.Platine.Sign.1" );

  AddTile( Dobbs::TILE_DOOR_BLUE_CENTER, "Door.Blue.1" );
  AddTile( Dobbs::TILE_DOOR_GREEN_CENTER, "Door.Green.1" );
  AddTile( Dobbs::TILE_DOOR_OPENED, "Door.Opened" );
  AddTile( Dobbs::TILE_DOOR_YELLOW_CENTER, "Door.Yellow.1" );
  AddTile( Dobbs::TILE_DOOR_BLUE_BOTTOM, "Door.Blue.2" );
  AddTile( Dobbs::TILE_DOOR_GREEN_BOTTOM, "Door.Green.2" );
  AddTile( Dobbs::TILE_DOOR_RED_BOTTOM, "Door.Red.2" );
  AddTile( Dobbs::TILE_DOOR_YELLOW_BOTTOM, "Door.Yellow.2" );

  AddTile( Dobbs::TILE_METAL_DOOR, "Tile.Door.Metal" );
  AddTile( Dobbs::TILE_METAL_DOOR_OPEN, "Tile.Door.Metal.Open" );

  AddTile( Dobbs::TILE_METAL_WALL_V, "Tile.Wall.Metal.V" );
  AddTile( Dobbs::TILE_METAL_WALL_H, "Tile.Wall.Metal.H" );
  AddTile( Dobbs::TILE_METAL_WALL_V_TILED, "Tile.Wall.Metal.V.Tiled" );
  AddTile( Dobbs::TILE_METAL_WALL_H_TILED, "Tile.Wall.Metal.H.Tiled" );

  AddTile( Dobbs::TILE_CYBER_BACK, "Tile.Cyber.Back" );

  AddTile( Dobbs::TILE_WALL_HOLDER_N, "Tile.Wall.Holder.N" );
  AddTile( Dobbs::TILE_WALL_HOLDER_E, "Tile.Wall.Holder.E" );
  AddTile( Dobbs::TILE_WALL_HOLDER_W, "Tile.Wall.Holder.W" );
  AddTile( Dobbs::TILE_WALL_HOLDER_S, "Tile.Wall.Holder.S" );

  AddTile( Dobbs::TILE_METAL_PLATFORM, "Tile.Platform.Metal" );

  AddTile( Dobbs::TILE_A, "Tile.A" );
  AddTile( Dobbs::TILE_B, "Tile.B" );
  AddTile( Dobbs::TILE_C, "Tile.C" );
  AddTile( Dobbs::TILE_D, "Tile.D" );
  AddTile( Dobbs::TILE_1, "Tile.1" );
  AddTile( Dobbs::TILE_2, "Tile.2" );
  AddTile( Dobbs::TILE_3, "Tile.3" );
  AddTile( Dobbs::TILE_4, "Tile.4" );

  AddTile( Dobbs::TILE_ARROW_RIGHT, "Tile.Arrow.Right" );
  AddTile( Dobbs::TILE_ARROW_LEFT, "Tile.Arrow.Left" );
  AddTile( Dobbs::TILE_LOCKDOWN, "Tile.Lockdown" );
  AddTile( Dobbs::TILE_LOCKDOWN_OPEN, "Tile.Lockdown.Open" );

  AddTile( Dobbs::TILE_TRAIN_TRACK, "Tile.Track" );

  AddTile( Dobbs::TILE_SPIKES_N, "Tile.Spikes.N" );
  AddTile( Dobbs::TILE_SPIKES_E, "Tile.Spikes.E" );
  AddTile( Dobbs::TILE_SPIKES_W, "Tile.Spikes.W" );
  AddTile( Dobbs::TILE_SPIKES_S, "Tile.Spikes.S" );

  AddTile( Dobbs::TILE_WATER_TOP, "Tile.Water.Top.0" );
  AddTile( Dobbs::TILE_WATER_TOP, "Tile.Water.Top.1" );
  AddTile( Dobbs::TILE_WATER_TOP, "Tile.Water.Top.2" );
  AddTile( Dobbs::TILE_WATER_TOP, "Tile.Water.Top.3" );

  AddTile( Dobbs::TILE_WATER, "Tile.Water" );

  AddTile( Dobbs::TILE_PLATINE_CHIP_E, "Tile.Grid.Chip.E" );
  AddTile( Dobbs::TILE_PLATINE_CHIP_W, "Tile.Grid.Chip.W" );
  AddTile( Dobbs::TILE_PLATINE_CHIP_S, "Tile.Grid.Chip.S" );
  AddTile( Dobbs::TILE_PLATINE_CHIP_N, "Tile.Grid.Chip.N" );
  AddTile( Dobbs::TILE_PLATINE_GRID_H, "Tile.Grid.H" );
  AddTile( Dobbs::TILE_PLATINE_GRID_V, "Tile.Grid.V" );

  AddTile( Dobbs::TILE_PLATINE_GRID_NE, "Tile.Grid.NE" );
  AddTile( Dobbs::TILE_PLATINE_GRID_NW, "Tile.Grid.NW" );
  AddTile( Dobbs::TILE_PLATINE_GRID_SE, "Tile.Grid.SE" );
  AddTile( Dobbs::TILE_PLATINE_GRID_SW, "Tile.Grid.SW" );

  AddTile( Dobbs::TILE_KELP_1, "Tile.Kelp.1.0" );
  //AddTile( Dobbs::TILE_KELP_1, "Tile.Kelp.1.1" );
  AddTile( Dobbs::TILE_KELP_2, "Tile.Kelp.2.0" );
  //AddTile( Dobbs::TILE_KELP_2, "Tile.Kelp.2.1" );
  AddTile( Dobbs::TILE_KELP_V_1, "Tile.KelpV.1.0" );
  //AddTile( Dobbs::TILE_KELP_V_1, "Tile.KelpV.1.1" );
  AddTile( Dobbs::TILE_KELP_V_2, "Tile.KelpV.2.0" );
  //AddTile( Dobbs::TILE_KELP_V_2, "Tile.KelpV.2.1" );

  AddTile( Dobbs::TILE_METAL_WALL_EDGE_LO, "Tile.Wall.Edge.LO" );
  AddTile( Dobbs::TILE_METAL_WALL_EDGE_RO, "Tile.Wall.Edge.RO" );
  AddTile( Dobbs::TILE_METAL_WALL_EDGE_LU, "Tile.Wall.Edge.LU" );
  AddTile( Dobbs::TILE_METAL_WALL_EDGE_RU, "Tile.Wall.Edge.RU" );

  // Create sounds for mouse click and rollover
  LoadSound( "Intro.1", "intro1.wav" );
  LoadSound( "Intro.2", "intro2.wav" );
  LoadSound( "Intro.3", "intro3.wav" );

  LoadSound( "Extro.1", "extro1.wav" );
  LoadSound( "Extro.2", "extro2.wav" );
  LoadSound( "Extro.3", "extro2b.wav" );
  LoadSound( "Extro.4", "extro3.wav" );
  LoadSound( "Extro.5", "extro4.wav" );
  LoadSound( "Extro.6", "extro5.wav" );

  LoadSound( "Click", "click.wav" );
  LoadSound( "RollOver", "rollover.wav" );

  LoadSound( "Collect", "collect.wav" );
  LoadSound( "Door.Open", "dooropen.wav" );

  LoadSound( "Player.Run.1", "run0.wav" );
  LoadSound( "Player.Run.2", "run1.wav" );
  LoadSound( "Player.Run.3", "run2.wav" );
  LoadSound( "Player.Land", "land.wav" );
  LoadSound( "Player.Explode", "smoke.wav" );
  LoadSound( "Player.Ice", "iceslip.wav" );
  LoadSound( "Player.Jump", "jump.wav" );

  LoadSound( "Player.Throw", "throwicon.wav" );
  LoadSound( "Icon.Bounce", "iconbounce.wav" );
  LoadSound( "Alert", "alert.wav" );
  LoadSound( "Laser.Explode", "laserexplode.wav" );
  LoadSound( "Cannon", "cannon.wav" );
  LoadSound( "Switch", "toggleswitch2.wav" );

  LoadSound( "Menu.Blip", "menublip.wav" );
  LoadSound( "Menu.Select", "menuselect.wav" );
  LoadSound( "Sub.Laser", "sublaser.wav" );
  LoadSound( "Sub.Motor", "motor2.wav" );

  LoadSound( "GunHit", "gunhit.wav" );
  LoadSound( "Shodan.Hit", "enemyhurt2.wav" );
  LoadSound( "Shodan.Hurt", "shodanhurt.wav" );

  LoadSound( "Player.Teleport", "teleport.wav" );

  LoadSound( "Laser.Shot", "laser.wav" );
  LoadSound( "Cannon.Explode", "cannonexplode.wav" );

  AddFont( "GUI.Small", "Arial", 20, 400 );
  AddFont( "Extro", "Arial", 40, 800 );

  Log( "Application()  Loading Introduction and Main Menu GUIs...\n" );
  m_pCurrentState = new CIntro();
  m_pCurrentState->Init();

  LoadSettings();

  if ( m_FullScreen )
  {
    m_FullScreen = false;
    ToggleWindowMode();
  }
  
  EnableCursor( false );

}



void Application::DeleteComponents()
{

  std::list<Button*>::iterator    itGUI( m_ListComponents.begin() );
  while ( itGUI != m_ListComponents.end() )
  {
    delete *itGUI;

    ++itGUI;
  }
  m_ListComponents.clear();

}



void Application::Release() 
{

  // Release GUI screens, if it hasn't already been done
  Log( "Application()  Releasing GUI...\n" );
  if ( m_pCurrentState )
  {
    m_pCurrentState->Exit();
    delete m_pCurrentState;
    m_pCurrentState = NULL;
  }

  DeleteComponents();

  // Release core components
  // NOTE:  This is not included in the destructor because it requires
  //        access to static members, which causes problems when done
  //        outside of WinMain().
  Log( "Application()  Releasing core...\n" );
  std::map<std::string,std::list<Sound*> >::iterator  itS( m_mapSounds.begin() );
  while ( itS != m_mapSounds.end() )
  {
    std::list<Sound*>::iterator   itS2( itS->second.begin() );
    while ( itS2 != itS->second.end() )
    {
      delete *itS2;

      ++itS2;
    }

    ++itS;
  }
  m_mapSounds.clear();

  m_Input.Release();
  Sound::Release();

}



void Application::UpdateTimed( const float ElapsedTime )
{

  if ( m_pCurrentState )
  {
    m_pCurrentState->UpdateTimed( ElapsedTime );
  }

  m_BGOffset += 16.0f * ElapsedTime;
  while ( m_BGOffset >= 64.0f )
  {
    m_BGOffset -= 64.0f;
  }

  ++m_AutoAnimationDelay;
  if ( m_AutoAnimationDelay >= 10 )
  {
    m_AutoAnimationDelay -= 10;
    m_AutoAnimation = ( ( m_AutoAnimation + 1 ) % 768 );
  }

}



void Application::Update() 
{

  if ( m_pNextState )
  {
    if ( m_pCurrentState )
    {
      m_pCurrentState->Exit();
      delete m_pCurrentState;
      m_pCurrentState = NULL;
    }

    g_App.DeleteComponents();

    m_pCurrentState = m_pNextState;
    m_pNextState    = NULL;
    if ( m_pCurrentState )
    {
      m_pCurrentState->Init();
    }
  }

  if ( m_pCurrentState )
  {
    m_pCurrentState->Update();
  }

  m_Input.Update();

}



void Application::Render() 
{

  // Begin 3D scene
  Activate();

  if ( SUCCEEDED( m_pD3DDevice->BeginScene() ) )
  {
    if ( m_pCurrentState )
    {
      if ( SUCCEEDED( m_pD3DSprite->Begin( D3DXSPRITE_ALPHABLEND ) ) )
      {
        m_pCurrentState->Render();

        std::list<Button*>::iterator    itB( m_ListComponents.begin() );
        while ( itB != m_ListComponents.end() )
        {
          Button*   pButton = (*itB );

          pButton->Render();
          ++itB;
        }

        if ( m_ShowCursor )
        {
          RenderTextureSection( "Mouse", m_Input.MouseX(), m_Input.MouseY() );
        }
        RenderBatchedTiles();

        m_pD3DSprite->End();
      }
    }
    else
    {
      Clear();
    }
    m_pD3DDevice->EndScene();

    m_pD3DDevice->Present( NULL, NULL, NULL, NULL );
  }

}



void Application::Destroy() 
{

  // release textures
  std::map<std::string,LPDIRECT3DTEXTURE9>::iterator  itTexture( m_mapTextures.begin() );
  while ( itTexture != m_mapTextures.end() )
  {
    LPDIRECT3DTEXTURE9    pTexture = itTexture->second;

    pTexture->Release();

    ++itTexture;
  }
  m_mapTextures.clear();

  // release all fonts
  std::map<std::string,LPD3DXFONT>::iterator    it( m_Fonts.begin() );
  while ( it != m_Fonts.end() )
  {
    it->second->Release();

    ++it;
  }
  m_Fonts.clear();

  m_pD3DSprite->Release();

  // Set isRunning flag to FALSE
  SaveSettings();
  isRunning = false;

}



void Application::Activate() 
{

  if ( m_pD3DDevice == NULL )
  {
    return;
  }

  // When DX applications are reset, some DX devices are lost and need to be
  // re-acquired and reset.  The return value from TestCooperativeLevel()
  // will indicate if this is necessary.
  HRESULT hr = m_pD3DDevice->TestCooperativeLevel();

  // If flagged as not reset, then main DX device can be reset
  if ( hr == D3DERR_DEVICENOTRESET ) 
  {
    Log( "Application()  Reseting Direct3D device...\n" );

    // First volatile resources must be re-acquired
    m_pD3DSprite->OnLostDevice();
    Text::ReacquireDevice();

    // Direct3D device can then be reset properly
    m_pD3DDevice->Reset( &d3dParam );

    // Once the main device is reset, the subdevices can also be reset
    m_pD3DSprite->OnResetDevice();
    Text::ResetDevice();

    // If flagged as lost, the device is not ready to be reset yet.
  } 
  else if ( hr == D3DERR_DEVICELOST ) 
  {
    Log("Application()  Direct3D device has been lost.  Waiting to reset...\n");
    // If TestCooperativeLevel() returns something other than DEVICENOTRESET,
    // D3DERR_DEVICELOST or OK, then it is an unhandled error and the
    // application should be exited.
  }
  else if ( hr != D3D_OK ) 
  {
    Log( "Application()  Error (%x) from TestCooperativeLevel()\n", hr );
    isRunning = false;
  }
}



bool Application::IsRunning() 
{ 
  return isRunning; 
}



void Application::MouseUpdate( int Buttons, int X, int Y )
{

  m_Input.UpdateMouse( Buttons, X, Y );

  std::list<Button*>::iterator    itB( m_ListComponents.begin() );
  while ( itB != m_ListComponents.end() )
  {
    Button*   pButton = (*itB );

    if ( pButton->UpdateMouse( Buttons, X, Y ) )
    {
      // Button was pushed
      m_pCurrentState->OnButtonPushed( pButton->m_ID );
    }

    ++itB;
  }

  m_pCurrentState->OnMouseUpdate( Buttons, X, Y );

}



LRESULT CALLBACK Application::WindowProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam ) 
{

  if ( g_pApp != NULL )
  {
    return g_pApp->WinProc( hWnd, message, wParam, lParam );
  }
  return DefWindowProc( hWnd, message, wParam, lParam );

}



LRESULT Application::WinProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam ) 
{

  // Check for handled messages
  switch ( message ) 
  {
    case WM_CREATE:
      {
        // Center Window on screen
        RECT    rc;

        GetWindowRect( hWnd, &rc );

        m_WindowPosWindowed.x = ( GetSystemMetrics( SM_CXSCREEN ) - ( rc.right - rc.left ) ) / 2;
        m_WindowPosWindowed.y = ( GetSystemMetrics( SM_CYSCREEN ) - ( rc.bottom - rc.top ) ) / 2;

        SetWindowPos( hWnd, NULL, m_WindowPosWindowed.x, m_WindowPosWindowed.y,
                      0, 0,
                      SWP_NOZORDER | SWP_NOSIZE );
      }
      break;
    case WM_SYSKEYUP:
      if ( wParam == VK_RETURN )
      {
        // Toggle Windowed/Fullscreen mode
        ToggleWindowMode();
        return 0;
      }
      break;
    case WM_KEYDOWN:
      m_Input.KeyIsDown( wParam );
      m_pCurrentState->OnKeyDown( wParam );
      break;
    case WM_KEYUP:
      m_Input.KeyIsUp( wParam );
      m_pCurrentState->OnKeyUp( wParam );
      break;
    case WM_CHAR:
      m_pCurrentState->OnChar( wParam );
      break;
    case WM_MOUSEWHEEL:
      {
        int   Delta = GET_WHEEL_DELTA_WPARAM( wParam );

        UINT  Ticks = 0;

        SystemParametersInfo( SPI_GETWHEELSCROLLLINES, 0, &Ticks, 0 );
           
        while ( Delta >= 120 )
        {
          for ( UINT i = 0; i < Ticks; ++i )
          {
            m_pCurrentState->OnMouseWheel( 1 );
          }
          Delta -= 120;
        }
        while ( Delta <= -120 )
        {
          for ( UINT i = 0; i < Ticks; ++i )
          {
            m_pCurrentState->OnMouseWheel( -1 );
          }
          Delta += 120;
        }
      }
      break;
    case WM_MOVE:
      Log( "Window moved to %d,%d\n", (int)(short) LOWORD(lParam), (int)(short) HIWORD(lParam) );
      break;
    case WM_DESTROY:
      Log( "WindowProc()  Received WM_DESTROY message.\n" );
      Destroy();
      return 0;
    case WM_ACTIVATE:
      Log( "WindowProc()  Received WM_ACTIVATEAPP message.\n" );
      if ( LOWORD( wParam ) == WA_INACTIVE )
      {
        m_BusyLoop = false;
      }
      else
      {
        m_BusyLoop = true;
        if ( IsMinimized( m_hWnd ) )
        {
          ShowWindow( m_hWnd, SW_RESTORE );
        }
        //Activate();
      }
      if ( m_pCurrentState )
      {
        m_pCurrentState->OnAppPaused( !m_BusyLoop );
      }
      return 0;
    case WM_PAINT:
      {
        PAINTSTRUCT   Struct;
        BeginPaint( m_hWnd, &Struct );
        EndPaint( m_hWnd, &Struct );
      }
      return TRUE;
    case WM_ERASEBKGND:
      return 1;
    case WM_MOUSEMOVE:
    case WM_LBUTTONDOWN:
    case WM_LBUTTONUP:
    case WM_LBUTTONDBLCLK:
    case WM_RBUTTONDOWN:
    case WM_RBUTTONUP:
    case WM_RBUTTONDBLCLK:
    case WM_MBUTTONDOWN:
    case WM_MBUTTONUP:
    case WM_MBUTTONDBLCLK:
      MouseUpdate( wParam, GET_X_LPARAM( lParam ), GET_Y_LPARAM( lParam ) );
      break;
    case WM_SETCURSOR:
      if ( LOWORD( lParam ) != HTCLIENT )
      {
        // show the cursor if it's over the border
        if ( !m_MouseCursorVisible )
        {
          m_MouseCursorVisible = true;
          ShowCursor( TRUE );
        }
      }
      else
      {
        if ( m_MouseCursorVisible )
        {
          m_MouseCursorVisible = false;
          ShowCursor( FALSE );
        }
      }
      break;
   }

   return DefWindowProc( hWnd, message, wParam, lParam );

}



void Application::ChangeGameState( GameState* pState )
{

  if ( m_pNextState != NULL )
  {
    delete m_pNextState;
    m_pNextState = NULL;
  }

  m_pNextState = pState;

}



void Application::AddGUI( Button* pButton )
{

  m_ListComponents.push_back( pButton );

}



void Application::CloseWindow()
{

  PostMessage( m_hWnd, WM_DESTROY, 0, 0 );

}



void Application::ToggleWindowMode()
{

  m_FullScreen          = !m_FullScreen;
  d3dParam.Windowed     = !m_FullScreen;

  DWORD       NewStyle    = WS_VISIBLE;
  DWORD       NewStyleEx  = 0;
  if ( m_FullScreen )
  {
    NewStyle |= WS_POPUP;
    NewStyleEx |= WS_EX_TOPMOST;

    // store previous position
    GetWindowPlacement( m_hWnd, &m_WPLWindowed );
    RECT    rc;

    GetWindowRect( m_hWnd, &rc );

    m_WindowPosWindowed.x = rc.left;
    m_WindowPosWindowed.y = rc.top;
  }
  else
  {
    NewStyle |= WS_CAPTION | WS_MINIMIZEBOX | WS_SYSMENU | WS_OVERLAPPED;
    NewStyleEx = WS_EX_WINDOWEDGE;
  }
  // First volatile resources must be re-acquired
  m_pD3DSprite->OnLostDevice();
  Text::ReacquireDevice();

  SetWindowLong( m_hWnd, GWL_STYLE, NewStyle );
  SetWindowLong( m_hWnd, GWL_EXSTYLE, NewStyleEx );

  // Direct3D device can then be reset properly
  m_pD3DDevice->Reset( &d3dParam );

  if ( !m_FullScreen )
  {
    SetWindowPlacement( m_hWnd, &m_WPLWindowed );
    SetWindowPos( m_hWnd, HWND_NOTOPMOST, m_WindowPosWindowed.x, m_WindowPosWindowed.y, 
                  0, 0, SWP_NOSIZE | SWP_FRAMECHANGED );
  }
  else
  {
    SetWindowPos( m_hWnd, NULL, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOZORDER | SWP_FRAMECHANGED );
  }
  // Once the main device is reset, the subdevices can also be reset
  m_pD3DSprite->OnResetDevice();
  Text::ResetDevice();

  OutputDebugString( L"Togglescreen done\n" );

}



void Application::SaveSettings()
{

  FILE*   ioInfo = fopen( Util::AppPath( "settings.cfg" ), "wb" );
  if ( ioInfo )
  {
    int   Volume = Sound::Volume();
    fwrite( &Volume, sizeof( Volume ), 1, ioInfo );

    fwrite( &m_FullScreen, sizeof( m_FullScreen ), 1, ioInfo );
    fclose( ioInfo );
  }

}



void Application::LoadSettings()
{

  int   Volume = 100;

  FILE*   ioInfo = fopen( Util::AppPath( "settings.cfg" ), "rb" );
  if ( ioInfo )
  {
    fread( &Volume, sizeof( Volume ), 1, ioInfo );

    fread( &m_FullScreen, sizeof( m_FullScreen ), 1, ioInfo );
    fclose( ioInfo );
  }

  Sound::SetVolume( Volume );

}



TextureSection Application::Section( const std::string& Section )
{

  std::map<std::string,TextureSection>::iterator    it( m_TextureSections.find( Section ) );
  if ( it != m_TextureSections.end() )
  {
    return it->second;
  }
  return TextureSection();

}



bool Application::LoadTexture( const std::string& TextureName )
{

  // Load texture
  LPDIRECT3DTEXTURE9      pTexture;

  if ( FAILED( D3DXCreateTextureFromFileExA( m_pD3DDevice,    // the device pointer
                                Util::AppPath( "images/%s", TextureName.c_str() ),      // the file name
                                D3DX_DEFAULT,    // default width
                                D3DX_DEFAULT,    // default height
                                D3DX_DEFAULT,    // no mip mapping
                                NULL,    // regular usage
                                D3DFMT_A8R8G8B8,    // 32-bit pixels with alpha
                                D3DPOOL_MANAGED,    // typical memory handling
                                D3DX_DEFAULT,    // no filtering
                                D3DX_DEFAULT,    // no mip filtering
                                D3DCOLOR_XRGB( 255, 0, 255 ),    // the hot-pink color key
                                NULL,    // no image info struct
                                NULL,    // not using 256 colors
                                &pTexture ) ) )    // load to sprite
  {
    Log( "Sprite()  Failed to load Texture '%s'\n", TextureName.c_str() );
    return false;
  }

  // Append image to sprite frame vector
  m_mapTextures[TextureName] = pTexture;
  Log( "Sprite()  Loaded Texture %i:  '%s'\n", (int)m_mapTextures.size() - 1, TextureName.c_str() );

  return true;

}



void Application::AddSection( const std::string& Section, const std::string& Texture, int X, int Y, int W, int H )
{

  LPDIRECT3DTEXTURE9    pTexture = NULL;

  std::map<std::string,LPDIRECT3DTEXTURE9>::iterator    it( m_mapTextures.find( Texture ) );
  if ( it != m_mapTextures.end() )
  {
    pTexture = it->second;
  }
  else
  {
    if ( LoadTexture( Texture ) )
    {
      pTexture = m_mapTextures[Texture];
    }
  }

  m_TextureSections[Section] = TextureSection( pTexture, X, Y, W, H );

}



void Application::AddTile( Dobbs::TileType Type, const std::string& TexSection )
{

  if ( m_Tiles.size() <= (size_t)Type )
  {
    m_Tiles.resize( Type + 1 );
  }
  m_Tiles[Type].Sections.push_back( Section( TexSection ) );

}



TextureSection Application::Tile( size_t TileIndex, size_t AnimFrame )
{

  if ( ( TileIndex >= m_Tiles.size() )
  ||   ( AnimFrame >= m_Tiles[TileIndex].Sections.size() ) )
  {
    return TextureSection();
  }
  AnimFrame = ( m_AutoAnimation % m_Tiles[TileIndex].Sections.size() );
  return m_Tiles[TileIndex].Sections[AnimFrame];

}



float Application::GetElapsedTime()
{

  if ( m_UsingQPF )
  {
    static LONGLONG m_llStopTime        = 0;
    static LONGLONG m_llLastElapsedTime = 0;
    double fElapsedTime;
    LARGE_INTEGER qwTime;
    
    QueryPerformanceCounter( &qwTime );
    if ( m_llStopTime == 0 )
    {
      m_llLastElapsedTime = qwTime.QuadPart;
      m_llStopTime = 1;
    }

    // Return the elapsed time
    fElapsedTime = (double)( qwTime.QuadPart - m_llLastElapsedTime ) / (double)m_llQPFTicksPerSec;
    m_llLastElapsedTime = qwTime.QuadPart;
    return (float)fElapsedTime;
  }
  else
  {
    DWORD CurrentTicks = GetTickCount();

    float   ElapsedTime = ( CurrentTicks - m_LastTicksPerFrame ) * 0.001f;

    m_LastTicksPerFrame = CurrentTicks;

    return ElapsedTime;
  }

}



DWORD Application::Run()
{

  // Create message struct
  MSG          msg;

  float         AccumulatedTime = 0.0f;

  // Initialize static members of application
  Init();


  while ( IsRunning() ) 
  {
    // Check if any messages are on the queue
    if ( !m_BusyLoop )
    {
      if ( !GetMessage( &msg, NULL, 0, 0 ) )
      {
        break;
      }
      while ( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) ) 
      {
        // Translate and dispatch to WindowProc if not WM_QUIT
        TranslateMessage( &msg );
        DispatchMessage( &msg );
      }
    }
    else
    {
      while ( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) ) 
      {
        // Translate and dispatch to WindowProc if not WM_QUIT
        GetMessage( &msg, NULL, 0, 0 );
        TranslateMessage( &msg );
        DispatchMessage( &msg );
      }
    }

    float   ElapsedTime = GetElapsedTime();

    g_App.UpdateTimed( ElapsedTime );

    AccumulatedTime += ElapsedTime;

    while ( AccumulatedTime >= 30 * 0.001f )
    {
      g_App.Update();
      AccumulatedTime -= 30 * 0.001f;
    }
    if ( g_App.IsRunning() )
    {
      // Render every frame for smoother movements
      g_App.Render();
    }
  }

  // Release static members of application
  g_App.Release();

  // Return WM_QUIT message to Windows
  return msg.wParam;

}



void Application::Clear()
{

  m_pD3DDevice->Clear( 0, NULL, D3DCLEAR_TARGET, 0xff000000, 0.0f, 0 );

}



void Application::RenderTextureSection( const std::string& TexSec, int X, int Y, DWORD Color, float Z )
{

  RenderTextureSection( Section( TexSec ), X, Y, Color, Z );

}



void Application::RenderTextureSection( const TextureSection& TexSec, int X, int Y, DWORD Color, float Z )
{

  m_TileBatcher.AddBatch( m_pD3DDevice, X, Y, Z, TexSec, Color, Color, Color, Color );
  /*
  D3DXVECTOR3 position( (float)X, (float)Y, Z );

  m_pD3DSprite->Draw( TexSec.pTexture,
                      &TexSec.rect,
                      NULL,
                      &position,
                      Color );
                      */

}



void Application::RenderTextureSectionWhitened( const TextureSection& TexSec, int X, int Y, DWORD Color, float Z )
{

  m_pD3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_SELECTARG1 );
  m_pD3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_DIFFUSE );

  SpriteBatcher     TempBatcher;

  TempBatcher.AddBatch( m_pD3DDevice, X, Y, Z, TexSec, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff );
  TempBatcher.Render( m_pD3DDevice );

  m_pD3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_DIFFUSE );
  m_pD3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_TEXTURE );
  m_pD3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );

}



void Application::RenderTextureSection( const TextureSection& TexSec, int X1, int Y1, int X2, int Y2, int X3, int Y3, int X4, int Y4, DWORD Color, float Z )
{

  m_TileBatcher.AddBatch( m_pD3DDevice, X1, Y1, X2, Y2, X3, Y3, X4, Y4, Z, TexSec, Color, Color, Color, Color );
  /*
  D3DXVECTOR3 position( (float)X, (float)Y, Z );

  m_pD3DSprite->Draw( TexSec.pTexture,
                      &TexSec.rect,
                      NULL,
                      &position,
                      Color );
                      */

}



void Application::RenderBatchedTiles()
{

  m_TileBatcher.Render( m_pD3DDevice );

}



void Application::RenderTextureSectionRotated( const std::string& TexSec, int X, int Y, float Angle, DWORD Color )
{

  RenderTextureSectionRotated( Section( TexSec ), X, Y, Angle, Color );

}



void Application::RenderTextureSectionRotated( const TextureSection& TexSec, int X, int Y, float Angle, DWORD Color )
{

  D3DXVECTOR2 spriteCentre = D3DXVECTOR2( ( TexSec.rect.right - TexSec.rect.left ) * 0.5f,
                                          ( TexSec.rect.bottom - TexSec.rect.top ) * 0.5f );

  // Screen position of the sprite
  D3DXVECTOR2 trans = D3DXVECTOR2( (float)X, (float)Y );

  // Build our matrix to rotate, scale and position our sprite
  D3DXMATRIX mat;

  D3DXMatrixTransformation2D( &mat, NULL, 0.0, NULL, &spriteCentre, Angle * 3.1415926f / 180.0f, &trans );

  m_pD3DSprite->SetTransform( &mat );

  m_pD3DSprite->Draw( TexSec.pTexture,
                 &TexSec.rect,
                 NULL, NULL,
                 Color );

  D3DXMATRIX    matIdentity;

  D3DXMatrixIdentity( &matIdentity );
  m_pD3DSprite->SetTransform( &matIdentity );

}



void Application::RenderTile( Dobbs::TileType Tile, int X, int Y, DWORD Color )
{

  RenderTextureSection( g_App.Tile( Tile ), X, Y, Color );

}



void Application::RenderTile( Dobbs::TileType Tile, int X1, int Y1, int X2, int Y2, int X3, int Y3, int X4, int Y4, DWORD Color )
{

  RenderTextureSection( g_App.Tile( Tile ), X1, Y1, X2, Y2, X3, Y3, X4, Y4, Color );

}



void Application::RenderText( const std::string& Font, const std::string& Text, int X, int Y, DWORD Color )
{

  std::map<std::string,LPD3DXFONT>::iterator    it( m_Fonts.find( Font ) );
  if ( it == m_Fonts.end() )
  {
    return;
  }

  RECT rct;

  rct.left    = X;
  rct.top     = Y;
  rct.right   = X + 800;
  rct.bottom  = Y + 600;

  LPD3DXFONT    pFont = it->second;

  pFont->DrawTextA( m_pD3DSprite, Text.c_str(), -1, &rct, DT_LEFT | DT_NOCLIP, Color );

}



void Application::RenderTextInArea( const std::string& Font, const std::string& Text, RECT& Area, DWORD Color )
{

  std::map<std::string,LPD3DXFONT>::iterator    it( m_Fonts.find( Font ) );
  if ( it == m_Fonts.end() )
  {
    return;
  }

  LPD3DXFONT    pFont = it->second;

  pFont->DrawTextA( m_pD3DSprite, Text.c_str(), -1, &Area, DT_LEFT | DT_NOCLIP | DT_WORDBREAK, Color );

}



void Application::RenderTextCentered( const std::string& Font, const std::string& Text, int X, int Y, DWORD Color )
{

  std::map<std::string,LPD3DXFONT>::iterator    it( m_Fonts.find( Font ) );
  if ( it == m_Fonts.end() )
  {
    return;
  }

  RECT rct;

  rct.left    = X;
  rct.top     = Y;
  rct.right   = X + 800;
  rct.bottom  = Y + 600;

  LPD3DXFONT    pFont = it->second;

  pFont->DrawTextA( m_pD3DSprite, Text.c_str(), -1, &rct, DT_CALCRECT | DT_NOCLIP, Color );

  int   W = rct.right - rct.left;
  int   H = rct.bottom - rct.top;
  rct.left = X - W / 2;
  rct.right = rct.left + W;

  pFont->DrawTextA( m_pD3DSprite, Text.c_str(), -1, &rct, DT_LEFT | DT_NOCLIP, Color );

}



void Application::RenderTextRightAligned( const std::string& Font, const std::string& Text, int X, int Y, DWORD Color )
{

  std::map<std::string,LPD3DXFONT>::iterator    it( m_Fonts.find( Font ) );
  if ( it == m_Fonts.end() )
  {
    return;
  }

  RECT rct;

  rct.left    = X;
  rct.top     = Y;
  rct.right   = X + 800;
  rct.bottom  = Y + 600;

  LPD3DXFONT    pFont = it->second;

  pFont->DrawTextA( m_pD3DSprite, Text.c_str(), -1, &rct, DT_CALCRECT | DT_NOCLIP, Color );

  int   W = rct.right - rct.left;
  int   H = rct.bottom - rct.top;
  rct.left = X - W;
  rct.right = X;

  pFont->DrawTextA( m_pD3DSprite, Text.c_str(), -1, &rct, DT_LEFT | DT_NOCLIP, Color );

}



void Application::AddFrameToAnimation( Dobbs::AnimationIndex AnimIndex, const std::string& TexSection, float FrameTime )
{

  Dobbs::Animation&    Anim( m_Animations[AnimIndex] );

  Anim.Sections.push_back( Section( TexSection ) );
  Anim.FrameSpeed.push_back( FrameTime );

}



void Application::AddFramesToAnimation( Dobbs::AnimationIndex AnimIndex, const std::string& TexSection, int StartIndex, int EndIndex, float FrameTime )
{

  Dobbs::Animation&    Anim( m_Animations[AnimIndex] );

  for ( int i = StartIndex; i <= EndIndex; ++i )
  {
    char    Temp[200];

    wsprintfA( Temp, "%s%d", TexSection.c_str(), i );
    Anim.Sections.push_back( Section( Temp ) );
    Anim.FrameSpeed.push_back( FrameTime );
  }

}



void Application::AddFont( const std::string& Name, const std::string& FontName, int size, int weight )
{

  if ( m_Fonts.find( Name ) != m_Fonts.end() )
  {
    m_Fonts[Name]->Release();
  }


  D3DXCreateFontA( m_pD3DDevice, size, 0, weight, 0, 0, DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, DEFAULT_QUALITY,
                   DEFAULT_PITCH | FF_DONTCARE, FontName.c_str(), &m_Fonts[Name] );

}



void Application::LoadSound( const std::string& SoundName, const std::string& Filename )
{

  Sound*    pSound = new Sound();
  pSound->PreloadSound( Filename.c_str() );

  m_mapSounds[SoundName].push_back( pSound );

}



void Application::PlaySound( const std::string& SoundName )
{

  std::map<std::string,std::list<Sound*> >::iterator  it( m_mapSounds.find( SoundName ) );
  if ( it == m_mapSounds.end() )
  {
    return;
  }
  // find first non playing sound or create duplicate
  std::list<Sound*>::iterator   itS( it->second.begin() );
  while ( itS != it->second.end() )
  {
    Sound*    pSound( *itS );

    if ( !pSound->IsPlaying() )
    {
      pSound->Play();
      return;
    }
    ++itS;
  }
  // TODO - create duplicate
  Sound*    pSound = new Sound();
  pSound->Duplicate( it->second.front() );
  m_mapSounds[SoundName].push_back( pSound );
  pSound->Play();

}



void Application::LoopSound( const std::string& SoundName )
{

  std::map<std::string,std::list<Sound*> >::iterator  it( m_mapSounds.find( SoundName ) );
  if ( it == m_mapSounds.end() )
  {
    return;
  }
  // find first non playing sound or create duplicate
  std::list<Sound*>::iterator   itS( it->second.begin() );
  while ( itS != it->second.end() )
  {
    Sound*    pSound( *itS );

    if ( !pSound->IsPlaying() )
    {
      pSound->Loop();
      return;
    }
    ++itS;
  }

}



bool Application::IsSoundPlaying( const std::string& SoundName )
{

  std::map<std::string,std::list<Sound*> >::iterator  it( m_mapSounds.find( SoundName ) );
  if ( it == m_mapSounds.end() )
  {
    return false;
  }
  // find first non playing sound or create duplicate
  std::list<Sound*>::iterator   itS( it->second.begin() );
  while ( itS != it->second.end() )
  {
    Sound*    pSound( *itS );

    if ( pSound->IsPlaying() )
    {
      return true;
    }
    ++itS;
  }
  return false;

}



void Application::StopSound( const std::string& SoundName )
{

  std::map<std::string,std::list<Sound*> >::iterator  it( m_mapSounds.find( SoundName ) );
  if ( it == m_mapSounds.end() )
  {
    return;
  }
  // find first non playing sound or create duplicate
  std::list<Sound*>::iterator   itS( it->second.begin() );
  while ( itS != it->second.end() )
  {
    Sound*    pSound( *itS );

    if ( pSound->IsPlaying() )
    {
      pSound->Stop();
    }
    ++itS;
  }

}



void Application::RenderBackground()
{

  RenderTextureSection( "BG.Empty", (int)m_BGOffset - 64, (int)m_BGOffset - 64 );

}



void Application::EnableCursor( bool Show )
{

  m_ShowCursor = Show;

}



void Application::ForceSpriteDraw()
{

  m_pD3DSprite->End();
  m_pD3DSprite->Begin( D3DXSPRITE_ALPHABLEND );

}